/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.inventory;

import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.inventory.ItemSlot;
import Krasnodar.rockstarnew.utility.inventory.group.impl.HotbarSlotsGroup;
import Krasnodar.rockstarnew.utility.inventory.slots.ArmorSlot;
import Krasnodar.rockstarnew.utility.inventory.slots.HotbarSlot;
import Krasnodar.rockstarnew.utility.inventory.slots.InventorySlot;
import Krasnodar.rockstarnew.utility.inventory.slots.OffhandSlot;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2815;
import net.minecraft.class_2868;
import org.jetbrains.annotations.NotNull;

public final class InventoryUtility
implements IMinecraft {
    public static HotbarSlot getHotbarSlot(int slotId) {
        return new HotbarSlot(slotId);
    }

    public static InventorySlot getInventorySlot(int slotId) {
        return new InventorySlot(slotId);
    }

    public static ArmorSlot getArmorSlot(int armorIndex) {
        return new ArmorSlot(armorIndex);
    }

    public static ArmorSlot getHelmetSlot() {
        return InventoryUtility.getArmorSlot(3);
    }

    public static ArmorSlot getChestplateSlot() {
        return InventoryUtility.getArmorSlot(2);
    }

    public static ArmorSlot getLeggingsSlot() {
        return InventoryUtility.getArmorSlot(1);
    }

    public static ArmorSlot getBootsSlot() {
        return InventoryUtility.getArmorSlot(0);
    }

    public static OffhandSlot getOffHandSlot() {
        return new OffhandSlot();
    }

    public static boolean hasItemInOffHand(class_1792 item) {
        return InventoryUtility.getOffHandSlot().contains(item);
    }

    public static boolean offHandItemMatches(Predicate<class_1799> predicate) {
        return InventoryUtility.getOffHandSlot().matches(predicate);
    }

    public static boolean isOffHandEmpty() {
        return InventoryUtility.getOffHandSlot().isEmpty();
    }

    public static void moveItem(ItemSlot from, ItemSlot to) {
        if (mc.method_1562() != null) {
            from.click();
            to.click();
            if (!to.isEmpty()) {
                from.click();
            }
            mc.method_1562().method_52787((class_2596)new class_2815(0));
        }
    }

    public static void quickMove(int from) {
        if (mc.method_1562() != null) {
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, from, 0, class_1713.field_7794, (class_1657)InventoryUtility.mc.field_1724);
        }
    }

    public static void moveItem(int from, int to) {
        InventoryUtility.moveItem(from, to, false);
    }

    public static void moveItem(int from, int to, boolean back) {
        if (mc.method_1562() != null) {
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, from, 0, class_1713.field_7790, (class_1657)InventoryUtility.mc.field_1724);
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, to, 0, class_1713.field_7790, (class_1657)InventoryUtility.mc.field_1724);
            if (back) {
                InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, from, 0, class_1713.field_7790, (class_1657)InventoryUtility.mc.field_1724);
            }
        }
    }

    public static void moveHalf(int from, int to) {
        if (mc.method_1562() != null) {
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, from, 1, class_1713.field_7790, (class_1657)InventoryUtility.mc.field_1724);
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, to, 0, class_1713.field_7790, (class_1657)InventoryUtility.mc.field_1724);
        }
    }

    public static void swapOneItem(int from, int to) {
        if (mc.method_1562() != null) {
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, from, 0, class_1713.field_7790, (class_1657)InventoryUtility.mc.field_1724);
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, to, 1, class_1713.field_7790, (class_1657)InventoryUtility.mc.field_1724);
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, from, 0, class_1713.field_7790, (class_1657)InventoryUtility.mc.field_1724);
        }
    }

    public static void hotbarSwap(int from, int to) {
        if (mc.method_1562() != null) {
            InventoryUtility.mc.field_1761.method_2906(InventoryUtility.mc.field_1724.field_7512.field_7763, from, to, class_1713.field_7791, (class_1657)InventoryUtility.mc.field_1724);
        }
    }

    public static boolean moveToHotbar(ItemSlot fromSlot, int hotbarSlotId) {
        HotbarSlot hotbarSlot = InventoryUtility.getHotbarSlot(hotbarSlotId);
        InventoryUtility.moveItem(fromSlot, hotbarSlot);
        return true;
    }

    public static boolean moveToArmor(ItemSlot fromSlot, int armorIndex) {
        ArmorSlot armorSlot = InventoryUtility.getArmorSlot(armorIndex);
        InventoryUtility.moveItem(fromSlot, armorSlot);
        return true;
    }

    public static void moveToOffHand(ItemSlot fromSlot) {
        OffhandSlot offHandSlot = InventoryUtility.getOffHandSlot();
        InventoryUtility.moveItem(fromSlot, offHandSlot);
    }

    @NotNull
    public static HotbarSlot getCurrentHotbarSlot() {
        return InventoryUtility.mc.field_1724 != null && InventoryUtility.mc.field_1724.method_31548() != null ? InventoryUtility.getHotbarSlot(InventoryUtility.mc.field_1724.method_31548().field_7545) : new HotbarSlot(0);
    }

    public static void selectHotbarSlot(int slotId) {
        if (InventoryUtility.mc.field_1724 != null && InventoryUtility.mc.field_1724.method_31548() != null && mc.method_1562() != null) {
            if (slotId >= 0 && slotId <= 8) {
                InventoryUtility.mc.field_1724.method_31548().field_7545 = slotId;
                mc.method_1562().method_52787((class_2596)new class_2868(InventoryUtility.mc.field_1724.method_31548().field_7545));
            } else {
                throw new IllegalArgumentException("Hotbar slot ID must be between 0 and 8");
            }
        }
    }

    public static void selectHotbarSlot(HotbarSlot slot) {
        InventoryUtility.selectHotbarSlot(slot.getSlotId());
    }

    public static boolean selectItemInHotbar(class_1792 item) {
        HotbarSlot slot = (HotbarSlot)new HotbarSlotsGroup().findItem(item);
        if (slot != null) {
            InventoryUtility.selectHotbarSlot(slot);
            return true;
        }
        return false;
    }

    public static int findItemInContainer(Predicate<class_1799> predicate) {
        if (InventoryUtility.mc.field_1724 != null && InventoryUtility.mc.field_1724.field_7512 != null) {
            for (int i = 0; i < InventoryUtility.mc.field_1724.field_7512.field_7761.size(); ++i) {
                class_1799 stack = InventoryUtility.mc.field_1724.field_7512.method_7611(i).method_7677();
                if (!predicate.test(stack)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static int findItemInContainer(class_1792 item) {
        return InventoryUtility.findItemInContainer((class_1799 stack) -> stack.method_7909() == item);
    }

    @Generated
    private InventoryUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

